package ga.core.goperators;

import ga.core.algorithm.util.RandomSingleton;

import java.util.Random;

/**
 * Abstract class for a probability operator.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public abstract class ProbabilityOp {
  private final int pOperation;
  private final Random rnd = RandomSingleton.getRandom();

  /**
   * Initializes the operator with the given probability.
   * 
   * @param pOperation
   *          The probability.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public ProbabilityOp(final int pOperation) {
    this.pOperation = pOperation;
  }

  /**
   * Calculates by internal probability and random number if the operator should
   * operate.
   * 
   * @return <code>true</code> if probability met.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public boolean doOperate() {
    return doOperate(pOperation);
  }

  /**
   * Calculates by given probability and random number if the operator should
   * operate.
   * 
   * @param probability
   *          The probability.
   * @return <code>true</code> if probability met.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public boolean doOperate(final int probability) {
    return rnd.nextInt(100) < probability;
  }

  /**
   * Getter for the random.
   * 
   * @return The random.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  protected Random getRandom() {
    return rnd;
  }

}
